<?php
/*
 * @package   stats_collector
 * @copyright Copyright (c)2023-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\UsageStats\Collector\Random\Adapter;

interface AdapterInterface
{
	/**
	 * Returns a number of bytes using a cryptographically secure pseudorandom number generator (CS-PRNG).
	 *
	 * @param   int  $length  How many bytes to retrieve
	 *
	 * @return  string  The randomly generated bytes
	 * @since   1.0.0
	 */
	public function getRandomBytes(int $length = 120): string;

	/**
	 * Is this adapter available for use in the current environment?
	 *
	 * @return  bool
	 * @since   1.0.0
	 */
	public function isAvailable(): bool;
}